CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM pg_views 
                    WHERE viewname = 'v_envia_produtos_fiscoreducaoz') THEN 
		DROP VIEW IF EXISTS v_envia_produtos_fiscoreducaoz;
        RAISE NOTICE 'v_envia_produtos_fiscoreducaoz removida.';
    END IF; 
	
	CREATE OR REPLACE VIEW public.v_envia_produtos_fiscoreducaoz AS
		SELECT g.cd_emp,
			g.cd_filial,
			g.cd_cx,
				CASE
					WHEN g.tpTotalizadorIsento = ''::character varying THEN 
						(g.tpTotalizador || g.percImposto)::character varying 
					WHEN g.tpTotalizador = 'S'::character varying THEN 
						(g.tpTotalizadorIsento || g.tpTotalizador || '1')::character varying 
					ELSE
						(g.tpTotalizadorIsento || '1')::character varying 
				END AS totalizador,
			g.ds_prod,
			g.cd_prod,
			g.codigo_produto,
			sum(g.qt_it) AS qt_it,
			g.unidade,
			round(sum(g.vlr_it), 4) AS vlr_it,
			g.dt_vd,
			g.tp_prod,
			round(sum(g.vlr_tot_liq_it), 4) AS vlr_tot_liq_it,
			round(sum(g.vlr_tot_liq_it_cancel), 4) AS vlr_tot_liq_it_cancel,
			round(sum(g.vlr_desc_it), 4) AS vlr_desc_it,
			g.nr_cest,
			g.ncm_prod
		   FROM ( SELECT a.cd_emp,
					a.cd_filial,
					a.cd_cx,
					b.cd_trib_fc,
					d.ds_prod,
					b.cd_prod,
					COALESCE(( SELECT e.cd_barra
						   FROM est_prod_cd_barra e
						  WHERE b.cd_prod = e.cd_prod
						 LIMIT 1), '0000000000000'::character varying) AS codigo_produto,
					sum(b.qt_it) AS qt_it,
					COALESCE(f.ds_un, 'UN'::character varying, f.ds_un) AS unidade,
					round(sum(b.vlr_it)/Count(b.vlr_it), 4) AS vlr_it,
					round(sum(b.vlr_desc_it), 4) AS vlr_desc_it,
					a.dt_vd,
					h.tp_prod,
					(case b.st_it when 1 then round(sum(b.vlr_it*b.qt_it - b.vlr_desc_it), 4) else 0 end) AS vlr_tot_liq_it,
					(case b.st_it when 2 then round(sum(b.vlr_it*b.qt_it - b.vlr_desc_it), 4) else 0 end) AS vlr_tot_liq_it_cancel,
					d.nr_cest,
					d.ncm_prod,
					ltrim(replace(to_char(b.tx_icms_it,'09.99'),'.',''))::character varying as percImposto,
					(CASE WHEN h.tp_prod = 10::numeric THEN 'S' ELSE 'T' END)::character VARYING AS tpTotalizador,
					(CASE
						WHEN b.cd_trib_fc::text = '040'::text OR btrim(b.cd_trib_fc::text) = '050'::text THEN 'I'::character varying
						WHEN btrim(b.cd_trib_fc::text) = '041'::text THEN 'N'::character varying
						WHEN btrim(b.cd_trib_fc::text) = '060'::text OR btrim(b.cd_trib_fc::text) = '010'::text THEN 'F'::character varying
						ELSE ''::character varying
					END) as tpTotalizadorIsento
				   FROM pdv_vd a
					 JOIN pdv_vd_it b ON a.cd_emp = b.cd_emp AND a.cd_filial = b.cd_filial AND a.cd_vd = b.cd_vd
					 JOIN est_prod d ON b.cd_emp = d.cd_emp AND b.cd_prod = d.cd_prod
					 LEFT JOIN est_prod_un_med f ON d.cd_un_vd = f.cd_ctr_un
					 LEFT JOIN est_prod_cpl h ON b.cd_emp = h.cd_emp AND b.cd_filial = h.cd_filial AND b.cd_prod = h.cd_prod         
				  GROUP BY b.cd_trib_fc, d.ds_prod, b.cd_prod, f.ds_un, a.dt_vd, a.cd_emp, a.cd_filial, a.cd_cx, h.tp_prod, b.st_it, d.nr_cest, d.ncm_prod, b.tx_icms_it
				  ORDER BY d.ds_prod) g
		  GROUP BY g.tpTotalizador, g.tpTotalizadorIsento, g.ds_prod, g.cd_prod, g.codigo_produto, g.unidade, g.dt_vd, g.cd_emp, g.cd_filial, g.cd_cx, g.	tp_prod, g.nr_cest, g.ncm_prod,g.percImposto;
	
	RAISE NOTICE 'View v_envia_produtos_fiscoreducaoz recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();